#include "../DetectedPlane.H"
#include "../LiDARPlaneDetector.H"
#include <nrt/PointCloud2/PointCloud2.H>
#include <vector>
#include <array>

//! Merge the set of DetectedPlanes based on the intersections of their hulls.
/*! If two DetectedPlanes' infinite planes satisfy the two given thresholds,
    then they are considered for a merge.  Merges are accomplished by
    projecting the hulls of both DetectedPlanes onto their average infinite
    plane, and then checking to see if there is a non-zero intersection. If so,
    then the resulting merged DetectedPlane's hull is the union of the two
    hulls.
 
    @param dotProductThresh Two planes' normals must have a dot product of over
    this thresholds to be considered for a merge.

    @param rhoThresh The absolutedifference between two planes' offsets must be
    below this threshold to be considered for a merge. 

    @param overlapThresh When trying to merge two planes, the area of their intersection
    must be greater than this value times the area of the smaller plane.
    */
template<size_t numRows>
std::vector<DetectedPlane> mergePolygons(std::vector<DetectedPlane> const & detectedPlanes,
    std::array<std::vector<LiDARGroup>, numRows> const & groups,
    nrt::PointCloud2 const & cloud, 
    float const dotProductThresh, float const rhoThresh, float const overlapThresh);
