#pragma once

#include "../DetectedPlane.H"
#include "../LiDARPlaneDetector.H"
#include <vector>

enum class RefineFrom {
  Groups,
  Indices 
};

//! Refine a detected plane by refitting it to its groups
template<size_t numRows>
DetectedPlane refinePlaneFromGroups(DetectedPlane const & plane,
    std::array<std::vector<LiDARGroup>, numRows> const & groups, nrt::PointCloud2 const & cloud);

//! Refine a detected plane by refitting it to all of its points
template<size_t numRows>
DetectedPlane refinePlaneFromPoints(DetectedPlane const & plane,
    std::array<std::vector<LiDARGroup>, numRows> const & groups, nrt::PointCloud2 const & cloud, RefineFrom const refinefrom);

//! Refine a detected plane by refitting it to all of its points using a least squares approach
/*! This method is from Appendix A. of Pathax et al 2010 */
DetectedPlane refinePlaneLeastSquares(DetectedPlane const & plane, nrt::PointCloud2 const & cloud);

//! Refine a detected plane by refitting it to all of its points 
/*! This uses the unconstrained least squares method from "Fast and Accurate Computation of Surface Normals from Range Images" Badino ICRA 2011.
    \warning THIS FUNCTION DOES NOT WORK */
template<size_t numRows>
DetectedPlane refinePlaneFromPointsFast (DetectedPlane const & plane,
    std::array<std::vector<LiDARGroup>, numRows> const & groups, nrt::PointCloud2 const & cloud, RefineFrom const refinefrom);
