#pragma once
#include <array>
#include <cmath>

namespace velodynehelpers
{
  constexpr float col2angle(int const col, int const maxcols=2188)
  {
    return col < maxcols/2 ?
      -((float(col) / float(maxcols)) * (2.0*M_PI)) :
      -((float(col) / float(maxcols)) * (2.0*M_PI)) + 2.0*M_PI;
  }

  template <size_t numRows> inline
  constexpr float row2angle(int const row);

  template <> inline
  constexpr float row2angle<32>(int const row)
  {
     return
        row ==  0 ? M_PI/2.0 - (-30.67 * M_PI/180.0) :
        row ==  1 ? M_PI/2.0 - (-29.33 * M_PI/180.0) :
        row ==  2 ? M_PI/2.0 - (   -28 * M_PI/180.0) :
        row ==  3 ? M_PI/2.0 - (-26.66 * M_PI/180.0) :
        row ==  4 ? M_PI/2.0 - (-25.33 * M_PI/180.0) :
        row ==  5 ? M_PI/2.0 - (   -24 * M_PI/180.0) :
        row ==  6 ? M_PI/2.0 - (-22.67 * M_PI/180.0) :
        row ==  7 ? M_PI/2.0 - (-21.33 * M_PI/180.0) :
        row ==  8 ? M_PI/2.0 - (   -20 * M_PI/180.0) :
        row ==  9 ? M_PI/2.0 - (-18.67 * M_PI/180.0) :
        row == 10 ? M_PI/2.0 - (-17.33 * M_PI/180.0) :
        row == 11 ? M_PI/2.0 - (   -16 * M_PI/180.0) :
        row == 12 ? M_PI/2.0 - (-14.67 * M_PI/180.0) :
        row == 13 ? M_PI/2.0 - (-13.33 * M_PI/180.0) :
        row == 14 ? M_PI/2.0 - (   -12 * M_PI/180.0) :
        row == 15 ? M_PI/2.0 - (-10.67 * M_PI/180.0) :
        row == 16 ? M_PI/2.0 - ( -9.33 * M_PI/180.0) :
        row == 17 ? M_PI/2.0 - (    -8 * M_PI/180.0) :
        row == 18 ? M_PI/2.0 - ( -6.66 * M_PI/180.0) :
        row == 19 ? M_PI/2.0 - ( -5.33 * M_PI/180.0) :
        row == 20 ? M_PI/2.0 - (    -4 * M_PI/180.0) :
        row == 21 ? M_PI/2.0 - ( -2.67 * M_PI/180.0) :
        row == 22 ? M_PI/2.0 - ( -1.33 * M_PI/180.0) :
        row == 23 ? M_PI/2.0 - (     0 * M_PI/180.0) :
        row == 24 ? M_PI/2.0 - (  1.33 * M_PI/180.0) :
        row == 25 ? M_PI/2.0 - (  2.67 * M_PI/180.0) :
        row == 26 ? M_PI/2.0 - (     4 * M_PI/180.0) :
        row == 27 ? M_PI/2.0 - (  5.33 * M_PI/180.0) :
        row == 28 ? M_PI/2.0 - (  6.67 * M_PI/180.0) :
        row == 29 ? M_PI/2.0 - (     8 * M_PI/180.0) :
        row == 30 ? M_PI/2.0 - (  9.33 * M_PI/180.0) :
                    M_PI/2.0 - ( 10.67 * M_PI/180.0) ;
  }

  //return ( veloAngles[row] + 90.0f ) * static_cast<float>( M_PI ) / 180.0f;

  // should be corrected by an xml (calibration) file in reality
  inline constexpr float row2angle64_2(int const row)
  {
     return
      row ==  0 ? (( -24.8000 - 90.0 ) * M_PI/180.0) :
      row ==  1 ? (( -24.3746 - 90.0 ) * M_PI/180.0) :
      row ==  2 ? (( -23.9492 - 90.0 ) * M_PI/180.0) :
      row ==  3 ? (( -23.5238 - 90.0 ) * M_PI/180.0) :
      row ==  4 ? (( -23.0984 - 90.0 ) * M_PI/180.0) :
      row ==  5 ? (( -22.6730 - 90.0 ) * M_PI/180.0) :
      row ==  6 ? (( -22.2476 - 90.0 ) * M_PI/180.0) :
      row ==  7 ? (( -21.8222 - 90.0 ) * M_PI/180.0) :
      row ==  8 ? (( -21.3968 - 90.0 ) * M_PI/180.0) :
      row ==  9 ? (( -20.9714 - 90.0 ) * M_PI/180.0) :
      row == 10 ? (( -20.5460 - 90.0 ) * M_PI/180.0) :
      row == 11 ? (( -20.1206 - 90.0 ) * M_PI/180.0) :
      row == 12 ? (( -19.6952 - 90.0 ) * M_PI/180.0) :
      row == 13 ? (( -19.2698 - 90.0 ) * M_PI/180.0) :
      row == 14 ? (( -18.8444 - 90.0 ) * M_PI/180.0) :
      row == 15 ? (( -18.4190 - 90.0 ) * M_PI/180.0) :
      row == 16 ? (( -17.9937 - 90.0 ) * M_PI/180.0) :
      row == 17 ? (( -17.5683 - 90.0 ) * M_PI/180.0) :
      row == 18 ? (( -17.1429 - 90.0 ) * M_PI/180.0) :
      row == 19 ? (( -16.7175 - 90.0 ) * M_PI/180.0) :
      row == 20 ? (( -16.2921 - 90.0 ) * M_PI/180.0) :
      row == 21 ? (( -15.8667 - 90.0 ) * M_PI/180.0) :
      row == 22 ? (( -15.4413 - 90.0 ) * M_PI/180.0) :
      row == 23 ? (( -15.0159 - 90.0 ) * M_PI/180.0) :
      row == 24 ? (( -14.5905 - 90.0 ) * M_PI/180.0) :
      row == 25 ? (( -14.1651 - 90.0 ) * M_PI/180.0) :
      row == 26 ? (( -13.7397 - 90.0 ) * M_PI/180.0) :
      row == 27 ? (( -13.3143 - 90.0 ) * M_PI/180.0) :
      row == 28 ? (( -12.8889 - 90.0 ) * M_PI/180.0) :
      row == 29 ? (( -12.4635 - 90.0 ) * M_PI/180.0) :
      row == 30 ? (( -12.0381 - 90.0 ) * M_PI/180.0) :
      row == 31 ? (( -11.6127 - 90.0 ) * M_PI/180.0) :
      row == 32 ? (( -11.1873 - 90.0 ) * M_PI/180.0) :
      row == 33 ? (( -10.7619 - 90.0 ) * M_PI/180.0) :
      row == 34 ? (( -10.3365 - 90.0 ) * M_PI/180.0) :
      row == 35 ? ((  -9.9111 - 90.0 ) * M_PI/180.0) :
      row == 36 ? ((  -9.4857 - 90.0 ) * M_PI/180.0) :
      row == 37 ? ((  -9.0603 - 90.0 ) * M_PI/180.0) :
      row == 38 ? ((  -8.6349 - 90.0 ) * M_PI/180.0) :
      row == 39 ? ((  -8.2095 - 90.0 ) * M_PI/180.0) :
      row == 40 ? ((  -7.7841 - 90.0 ) * M_PI/180.0) :
      row == 41 ? ((  -7.3587 - 90.0 ) * M_PI/180.0) :
      row == 42 ? ((  -6.9333 - 90.0 ) * M_PI/180.0) :
      row == 43 ? ((  -6.5079 - 90.0 ) * M_PI/180.0) :
      row == 44 ? ((  -6.0825 - 90.0 ) * M_PI/180.0) :
      row == 45 ? ((  -5.6571 - 90.0 ) * M_PI/180.0) :
      row == 46 ? ((  -5.2317 - 90.0 ) * M_PI/180.0) :
      row == 47 ? ((  -4.8063 - 90.0 ) * M_PI/180.0) :
      row == 48 ? ((  -4.3810 - 90.0 ) * M_PI/180.0) :
      row == 49 ? ((  -3.9556 - 90.0 ) * M_PI/180.0) :
      row == 50 ? ((  -3.5302 - 90.0 ) * M_PI/180.0) :
      row == 51 ? ((  -3.1048 - 90.0 ) * M_PI/180.0) :
      row == 52 ? ((  -2.6794 - 90.0 ) * M_PI/180.0) :
      row == 53 ? ((  -2.2540 - 90.0 ) * M_PI/180.0) :
      row == 54 ? ((  -1.8286 - 90.0 ) * M_PI/180.0) :
      row == 55 ? ((  -1.4032 - 90.0 ) * M_PI/180.0) :
      row == 56 ? ((  -0.9778 - 90.0 ) * M_PI/180.0) :
      row == 57 ? ((  -0.5524 - 90.0 ) * M_PI/180.0) :
      row == 58 ? ((  -0.1270 - 90.0 ) * M_PI/180.0) :
      row == 59 ? ((   0.2984 - 90.0 ) * M_PI/180.0) :
      row == 60 ? ((   0.7238 - 90.0 ) * M_PI/180.0) :
      row == 61 ? ((   1.1492 - 90.0 ) * M_PI/180.0) :
      row == 62 ? ((   1.5746 - 90.0 ) * M_PI/180.0) :
                  ((   2.0000 - 90.0 ) * M_PI/180.0) ;
  }
  inline constexpr float row2angle64(int const row)
  {
     return
      row ==  0 ? M_PI/2.0 - ( -24.8000 * M_PI/180.0) :
      row ==  1 ? M_PI/2.0 - ( -24.3746 * M_PI/180.0) :
      row ==  2 ? M_PI/2.0 - ( -23.9492 * M_PI/180.0) :
      row ==  3 ? M_PI/2.0 - ( -23.5238 * M_PI/180.0) :
      row ==  4 ? M_PI/2.0 - ( -23.0984 * M_PI/180.0) :
      row ==  5 ? M_PI/2.0 - ( -22.6730 * M_PI/180.0) :
      row ==  6 ? M_PI/2.0 - ( -22.2476 * M_PI/180.0) :
      row ==  7 ? M_PI/2.0 - ( -21.8222 * M_PI/180.0) :
      row ==  8 ? M_PI/2.0 - ( -21.3968 * M_PI/180.0) :
      row ==  9 ? M_PI/2.0 - ( -20.9714 * M_PI/180.0) :
      row == 10 ? M_PI/2.0 - ( -20.5460 * M_PI/180.0) :
      row == 11 ? M_PI/2.0 - ( -20.1206 * M_PI/180.0) :
      row == 12 ? M_PI/2.0 - ( -19.6952 * M_PI/180.0) :
      row == 13 ? M_PI/2.0 - ( -19.2698 * M_PI/180.0) :
      row == 14 ? M_PI/2.0 - ( -18.8444 * M_PI/180.0) :
      row == 15 ? M_PI/2.0 - ( -18.4190 * M_PI/180.0) :
      row == 16 ? M_PI/2.0 - ( -17.9937 * M_PI/180.0) :
      row == 17 ? M_PI/2.0 - ( -17.5683 * M_PI/180.0) :
      row == 18 ? M_PI/2.0 - ( -17.1429 * M_PI/180.0) :
      row == 19 ? M_PI/2.0 - ( -16.7175 * M_PI/180.0) :
      row == 20 ? M_PI/2.0 - ( -16.2921 * M_PI/180.0) :
      row == 21 ? M_PI/2.0 - ( -15.8667 * M_PI/180.0) :
      row == 22 ? M_PI/2.0 - ( -15.4413 * M_PI/180.0) :
      row == 23 ? M_PI/2.0 - ( -15.0159 * M_PI/180.0) :
      row == 24 ? M_PI/2.0 - ( -14.5905 * M_PI/180.0) :
      row == 25 ? M_PI/2.0 - ( -14.1651 * M_PI/180.0) :
      row == 26 ? M_PI/2.0 - ( -13.7397 * M_PI/180.0) :
      row == 27 ? M_PI/2.0 - ( -13.3143 * M_PI/180.0) :
      row == 28 ? M_PI/2.0 - ( -12.8889 * M_PI/180.0) :
      row == 29 ? M_PI/2.0 - ( -12.4635 * M_PI/180.0) :
      row == 30 ? M_PI/2.0 - ( -12.0381 * M_PI/180.0) :
      row == 31 ? M_PI/2.0 - ( -11.6127 * M_PI/180.0) :
      row == 32 ? M_PI/2.0 - ( -11.1873 * M_PI/180.0) :
      row == 33 ? M_PI/2.0 - ( -10.7619 * M_PI/180.0) :
      row == 34 ? M_PI/2.0 - ( -10.3365 * M_PI/180.0) :
      row == 35 ? M_PI/2.0 - (  -9.9111 * M_PI/180.0) :
      row == 36 ? M_PI/2.0 - (  -9.4857 * M_PI/180.0) :
      row == 37 ? M_PI/2.0 - (  -9.0603 * M_PI/180.0) :
      row == 38 ? M_PI/2.0 - (  -8.6349 * M_PI/180.0) :
      row == 39 ? M_PI/2.0 - (  -8.2095 * M_PI/180.0) :
      row == 40 ? M_PI/2.0 - (  -7.7841 * M_PI/180.0) :
      row == 41 ? M_PI/2.0 - (  -7.3587 * M_PI/180.0) :
      row == 42 ? M_PI/2.0 - (  -6.9333 * M_PI/180.0) :
      row == 43 ? M_PI/2.0 - (  -6.5079 * M_PI/180.0) :
      row == 44 ? M_PI/2.0 - (  -6.0825 * M_PI/180.0) :
      row == 45 ? M_PI/2.0 - (  -5.6571 * M_PI/180.0) :
      row == 46 ? M_PI/2.0 - (  -5.2317 * M_PI/180.0) :
      row == 47 ? M_PI/2.0 - (  -4.8063 * M_PI/180.0) :
      row == 48 ? M_PI/2.0 - (  -4.3810 * M_PI/180.0) :
      row == 49 ? M_PI/2.0 - (  -3.9556 * M_PI/180.0) :
      row == 50 ? M_PI/2.0 - (  -3.5302 * M_PI/180.0) :
      row == 51 ? M_PI/2.0 - (  -3.1048 * M_PI/180.0) :
      row == 52 ? M_PI/2.0 - (  -2.6794 * M_PI/180.0) :
      row == 53 ? M_PI/2.0 - (  -2.2540 * M_PI/180.0) :
      row == 54 ? M_PI/2.0 - (  -1.8286 * M_PI/180.0) :
      row == 55 ? M_PI/2.0 - (  -1.4032 * M_PI/180.0) :
      row == 56 ? M_PI/2.0 - (  -0.9778 * M_PI/180.0) :
      row == 57 ? M_PI/2.0 - (  -0.5524 * M_PI/180.0) :
      row == 58 ? M_PI/2.0 - (  -0.1270 * M_PI/180.0) :
      row == 59 ? M_PI/2.0 - (   0.2984 * M_PI/180.0) :
      row == 60 ? M_PI/2.0 - (   0.7238 * M_PI/180.0) :
      row == 61 ? M_PI/2.0 - (   1.1492 * M_PI/180.0) :
      row == 62 ? M_PI/2.0 - (   1.5746 * M_PI/180.0) :
                  M_PI/2.0 - (   2.0000 * M_PI/180.0) ;
  }

  template <> inline
  constexpr float row2angle<64>(int const row)
  {
    return row2angle64_2(63-row);
  }


  // A helper class to populate a rowtable
  template <size_t numRows> inline
  constexpr int rowTable( int i );

  template <> inline
  constexpr int rowTable<32>( int i )
  {
    return ( i < 16 ) ? ( i * 2 ) : ( ( i - 16 ) * 2 + 1 );
  }

  template <> inline
  constexpr int rowTable<64>( int i )
  {
    return i;
  }

  //! Convert a row/column into an index
  template <size_t numRows> inline
  constexpr int index(int const row, int const col);

  template <> inline
  constexpr int index<32>(int const row, int const col)
  {
    return col*32 + rowTable<32>(row);
  }

  template <> inline
  constexpr int index<64>(int const row, int const col)
  {
    return col*64 + rowTable<64>(row);
  }

  // ######################################################################
  //! Convert and index into a row
  template <size_t numRows>
  inline int idx2row(int idx);

  template <>
  inline int idx2row<32>(int idx)
  {
    int const seq = idx % 32;
    int const row = (seq % 2) ? 16+seq/2 : seq/2;
    return row;
  }

  template <>
  inline int idx2row<64>(int idx)
  {
    return idx % 64;
  }

  // ######################################################################
  //! Convert an index into a column
  template <size_t numRows>
  inline int idx2col(int idx);

  template <>
  inline int idx2col<32>(int idx)
  {
    int const seq = idx % 32;
    return (idx - seq)/32;
  }

  template <>
  inline int idx2col<64>(int idx)
  {
    int const seq = idx % 64;
    return (idx - seq)/64;
  }
}
