#pragma once

#include <nrt/PointCloud2/PointCloud2.H>
#include <PointCloud/Features/RangeImage.H>
#include <PointCloud/Features/VelodyneHelpers.H>
#include <PointCloud/Features/Planes/details/FrameTiming.H>

//! Computes the normals of a Velodyne cloud using the "Fast and Approximate Least Squares" method
//! from Badino, et. al. 2011.
template <size_t numRows>
class VelodyneNormalsFLAS
{
  template <class T>
  using Image = nrt::Image<nrt::PixGray<T>>;

  public:
    VelodyneNormalsFLAS(int d_theta = 3, int d_phi = 1);

    void compute(nrt::PointCloud2 & cloud);

  protected:
    std::tuple<Image<double>, Image<double>, Image<double>>
    make_integral_images(Image<float> const & range);

  private:
    int const d_theta_;
    int const d_phi_;
    int const max_columns_; // max columns in the range image
    std::vector<float> thetas_;
    std::map<float, size_t> theta_indices_;
    std::vector<std::array<Eigen::Matrix3d, numRows>> M_;
    std::vector<std::array<Eigen::Vector3d, numRows>> v_;
    nrt::Image<nrt::PixGray<double>> vx_;
    nrt::Image<nrt::PixGray<double>> vy_;
    nrt::Image<nrt::PixGray<double>> vz_;
};

