#ifndef IMUSTATEM_H
#define IMUSTATEM_H

#include "Message.h"
#include <string>

namespace DataLog
{
	class IMUStateM : public Message
	{
	public:
		IMUStateM(FILE* r);
        IMUStateM(double p_timestamp, const float p_quat[4], const float p_accel[3], std::string p_sensorName="xsens_1", std::string p_sensorType="xsens_MTi-G");
		static Message* readMessage(FILE*r);
		static const char* MSG_NAME;
		const char* getMessageName() const
		{
			return MSG_NAME;
		}

		const std::string& getSensorName() const { return sensorName; }
		const std::string& getSensorType() const { return sensorType; }

		const float* getQuat() const { return &quat[0]; }
		const float* getAccel() const { return &accel[0]; }
        
    protected:
        virtual unsigned int writeMessageData(FILE *file);
            
	private:
		std::string sensorName;
		std::string sensorType;
		float quat[4];
		float accel[3];
	};
}

#endif
