#ifndef LASER_RANGE_2D_CONFIG_M_H
#define LASER_RANGE_2D_CONFIG_M_H

#include "Message.h"

#include <string>
#include <string.h>

namespace DataLog
{
    
    class LaserRange2DConfigM: public Message{
        public:
        LaserRange2DConfigM(FILE* r);
        LaserRange2DConfigM(double p_timestamp, std::string p_sensorName="hok_utm30_1", std::string p_sensorType="Hokuyo_UTM-30LX");
        static Message* readMessage(FILE*r);
        static const char* MSG_NAME;
        const char* getMessageName() const
        {
            return MSG_NAME;
        }

        const std::string& getSensorName() const { return sensorName; }
        const std::string& getSensorType() const { return sensorType; }
        
        unsigned int getNumberOfBeams() const { return numberOfBeams; }
        unsigned int getMaxRangeMM() const { return maxRangeMM; }
        float getFieldOfViewDeg() const { return fieldOfViewDeg; }
        const float * getOrientationQuat() const { return orientationQuat; }
        const float * getPositionMM() const { return positionMM; }

        void setNumberOfBeams(unsigned int nr) { numberOfBeams = nr; }
        void setMaxRangeMM(unsigned int maximumRangeMM) { maxRangeMM = maximumRangeMM; }
        void setFieldOfViewDeg(float fov) { fieldOfViewDeg = fov; }
        void setOrientationQuat(float ori[4]) { memcpy(orientationQuat, ori, sizeof(float)*4); }
        void setPositionMM(float pos[3]) { memcpy(positionMM, pos, sizeof(float) * 3); }

        protected:
            virtual unsigned int writeMessageData(FILE *file);

        private:
            std::string sensorName;
            std::string sensorType;

            unsigned int numberOfBeams;
            unsigned int maxRangeMM;
            float fieldOfViewDeg;
            float orientationQuat[4];
            float positionMM[3];
    };
    
}

#endif
