#include "LogFile.h"
#include "LaserRange2DDataM.h"
#include "LaserRange2DConfigM.h"
#include "IMUStateM.h"
#include <stdlib.h>
#include <iostream>

using namespace std;

int main(int argc, char *argv[])
{
	if ((argc<2)||(argc>3))
	{
		std::cout << "Usage: ./sample_console <logfile> [optional: seek to position in seconds]" << std::endl;
		return 1;
	}
	int seekTo=-1;
	if (argc==3)
	{
		seekTo=atoi(argv[2]);
	}

	std::cout << "Trying to open the file: '" << argv[1] << "'" << std::endl;

    DataLog::LogFile* log=new DataLog::LogFile();
	if (!log->open(argv[1]))
	{
		std::cerr << "Error loading the log file" << std::endl;
		delete log;
		return 2;
	}

    log->handleMessage<DataLog::LaserRange2DDataM>();
    log->handleMessage<DataLog::LaserRange2DConfigM>();
    log->handleMessage<DataLog::IMUStateM>();

	if (seekTo!=-1)
	{
		std::cout << "Seeking to " << seekTo << " seconds ";
		if (log->seek(seekTo))
		{
                        std::cout << "succeeded" << std::endl;
		}
		else
		{
                        std::cout << "failed" << std::endl;
			return 3;
		}
	}

    DataLog::Message* msg=0;
	while (1)
	{
		msg=log->readNextMessage();
		if (!msg)
			break;

		std::cout << "Timestamp: " << msg->getTimestamp() << " | ";

		bool messageKnown=0;

        DataLog::LaserRange2DDataM* laser=dynamic_cast<DataLog::LaserRange2DDataM*>(msg);
		if (laser)
		{
                    std::cout << "Laser data from a '" << laser->getSensorType() << "' sensor with " << laser->getRangeData().size() << " data values. Timestamp: " << laser->getTimestamp() << " Sensor timestamp: " << laser->getSensorTimestamp() << std::endl;
                    std::cout << "LRF, " << ::std::fixed << laser->getTimestamp() << ": ";
                        for (uint i=0; i+1 < laser->getRangeData().size(); i++)
                        {
                            std::cout << laser->getRangeData()[i] << ", ";
                        }
                        // Add last value without ","
                        if (laser->getRangeData().size() > 0)
                        {
                            std::cout << laser->getRangeData().back();
                        }
                        std::cout << std::endl;
			messageKnown=1;
		}

        DataLog::LaserRange2DConfigM* config=dynamic_cast<DataLog::LaserRange2DConfigM*>(msg);
        if (config)
        {
            std::cout << "Laser config for type '" << config->getSensorType() << "' and name '"<< config->getSensorName()<<"' sensor. Timestamp: " << config->getTimestamp() << std::endl;
            std::cout << "Config info:"<<endl;
            cout<<"\tNumber of beams: " << config->getNumberOfBeams()<<endl;
            cout<<"\tRange in mm: " << config->getMaxRangeMM()<<endl;
            cout<<"\tField of view in degrees: " << config->getFieldOfViewDeg()<<endl;
            cout<<"\tOrientation quat: " << config->getOrientationQuat()[0]<<" "<<config->getOrientationQuat()[1]<<" "<<config->getOrientationQuat()[2]<<" "<<config->getOrientationQuat()[3]<<endl;
            cout<<"\tPosition in mm: " << config->getPositionMM()[0]<<" "<<config->getPositionMM()[1]<<" "<<config->getPositionMM()[2]<<endl;
            
            messageKnown=1;
        }

        // we got IMU data from the log file
        DataLog::IMUStateM* imu=dynamic_cast<DataLog::IMUStateM*>(msg);
		if (imu)
		{
                        std::cout << "IMU data from a '" << imu->getSensorType() << "' sensor. Pose Quaternion: " << imu->getQuat()[0] << " " << imu->getQuat()[1] << " " << imu->getQuat()[2] << " " << imu->getQuat()[3] << std::endl;
			messageKnown=1;
		}

		if (!messageKnown)
		{
			std::cout << "Unknown message" << std::endl;
		}

		delete msg;

	};

        std::cout << "Finished reading the log file" << std::endl;


	delete log;


	return 0;
}

