#pragma once

#include <nrt/Core/Util/CompilerUtil.H>

NRT_BEGIN_UNCHECKED_INCLUDES;
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#include <Eigen/Geometry>
#pragma GCC diagnostic pop
NRT_END_UNCHECKED_INCLUDES;

#include <vector>
#include <string>
#include <chrono>

void writePath(std::string const & filename,
    std::vector<Eigen::Isometry3d> const & path, std::vector<std::chrono::microseconds> const & times);

std::tuple<Eigen::Vector3d, Eigen::Vector3d> filterCamera(std::vector<Eigen::Isometry3d> const & transformHistory);
