#!/usr/bin/env python

import numpy as np
from scipy import linalg
import matplotlib.pyplot as plt

def uphat(x):
  v1 = x[0]
  v2 = x[1]
  a  = x[2]

  return np.matrix([[0, -a, v1],
                    [a, 0, v2],
                    [0, 0, 0]])

def downhat(X):
  v1 = X[0,2]
  v2 = X[1,2]
  a  = X[1,0]

  return np.matrix([v1, v2, a]).transpose()

def expm(X): return np.matrix(linalg.expm(X))

def logm(X): return np.real(np.matrix(linalg.logm(X)))

#def logm(X):
#  theta = np.arccos(X[0,0])
#  t = X[0:2,2]
#  R = X[0:2,0:2]
#
#  t = R.transpose() * t
#  return uphat([t[0], t[1], theta])


#xys = np.linspace(-10, 10, 100)
#thetas = np.linspace(0, 2*np.pi, 100)
#Xs,Ys,Ts = np.meshgrid(xys, xys, thetas)

Sigma = np.matrix([[1, 0, 0],
                   [0, 1, 0],
                   [0, 0, 1]])

u = np.matrix([0, 0, 0]).transpose()
U = expm(uphat(u))


minxy,maxxy,nxy = -5, 5,       10
mint,maxt,nt    =  0, 2*np.pi, 10

F = np.zeros((nxy, nxy))

Uinv = np.linalg.inv(U)

np.set_printoptions(precision=3)

for xi_, x_ in enumerate(np.linspace(minxy, maxxy, nxy)):
  for yi_, y_ in enumerate(np.linspace(minxy, maxxy, nxy)):
    for ti_, t_ in enumerate(np.linspace(mint, maxt, nt)):
      g = [x_, y_, t_]
      G = expm(uphat(g))

      y = downhat(logm( Uinv * G ))

      print "{0:+.3f} {1:+.3f} {2:+.3f} : {3}" .format ( x_,y_,t_, y.transpose() * y)

      #f = np.exp( (y.transpose() * Sigma * y) )
      #print 'f: ', (x_,y_,t_), f
      #print 'f: ',  np.linalg.norm(f)

      #print f
      #F[yi_, xi_] += np.linalg.norm(f)
      #F[yi_, xi_] += np.real(f)

#plt.imshow(F)
#plt.show()
