function [] = distance_testing()

points = rand(2, 5);

theta = 15 * pi/180;
R = [cos(theta) -sin(theta); sin(theta) cos(theta)];
t = [0.1; 0.05];

cov = [1 0; 0 0.5];

points_t = transformPoints( points, R, t );
[nn1, dist1] = match_bruteForce(points_t, points);
[nn2, dist2] = match_bruteForceMahalanobis(points_t, points, cov);


clf
hold on; axis square; grid on;
plot(points(1,:), points(2,:), 'o');
plot(points_t(1,:), points_t(2,:), 'x');
for i=1:length(nn1)
    plot([points(1,i) points_t(1,i)], [points(2,i) points_t(2,i)], 'Color', [.6,.6,.6], 'LineWidth', 5)   
    plot([points(1,i) points_t(1,nn1(i))], [points(2,i) points_t(2,nn1(i))], 'g', 'LineWidth', 2)   
    plot([points(1,i) points_t(1,nn2(i))], [points(2,i) points_t(2,nn2(i))], '--r', 'LineWidth', 2)  
end


end

function [match mindist] = match_bruteForce(q, p)
    m = size(p,2);
    n = size(q,2);    
    match = zeros(1,m);
    mindist = zeros(1,m);
    for ki=1:m
        d=zeros(1,n);
        for ti=1:2
            d=d+(q(ti,:)-p(ti,ki)).^2;
        end
        [mindist(ki),match(ki)]=min(d);
    end
    
    mindist = sqrt(mindist);
end
    
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function [match mindist] = match_bruteForceMahalanobis(q, p, Cov)
    m = size(p,2);
    n = size(q,2);    
    match = zeros(1,m);
    mindist = zeros(1,m);
    for ki=1:m
        d=zeros(1,n);
        for ti=1:n
            diff = q(:,ti) - p(:,ki);
            d(ti) = diff' * inv(Cov) * diff;            
        end
        [mindist(ki),match(ki)]=min(d);
    end
    
    mindist = sqrt(mindist);
end 