% create a box and shift it
npoints = 10;
noise   = .01;
dense   = true;
translation = [0.01 0 0]';
rotation    = rotationmat3D(0, [0 0 1]');
covariance = eye(3);

box1 = makeBox( npoints, noise, dense );
box2 = makeBox( npoints, noise, dense );
% box2 = box1;
box2 = transformPoints( box2, rotation, translation );

clf
hold on
plotBox(box1, 'red');
plotBox(box2, 'green');

% Do that ICP
[Tr, Tt] = icp( box2, box1, 'Matching', 'kdTreeMahalanobis', 'Covariance', covariance )
% [Tr, Tt] = icp( box2, box1 )

% print Errors
Error_Tr = abs(Tr - rotation)
Error_Tt = abs(Tt - translation)