#pragma once

#include "DetectedPlane.H"
#include <nrt/PointCloud2/Common/Correspondence.H>
#include <vector>

Eigen::Isometry3d findTransform(nrt::Correspondences const & correspondences,
    std::vector<DetectedPlane> const & frame1Planes, std::vector<DetectedPlane> const & frame2Planes,
    nrt::Optional<Eigen::Matrix3d&> translationCovariance = nrt::OptionalEmpty,
    nrt::Optional<Eigen::Matrix3d&> rotationCovariance = nrt::OptionalEmpty
    );

Eigen::Matrix3f findRotation(nrt::Correspondences const & correspondences,
    std::vector<DetectedPlane> const & frame1Planes, std::vector<DetectedPlane> const & frame2Planes,
    nrt::Optional<Eigen::Matrix4d&> covariance = nrt::OptionalEmpty,
    nrt::Optional<double&> uncertaintyVolume = nrt::OptionalEmpty);

Eigen::Translation3f findTranslation(nrt::Correspondences const & correspondences,
    std::vector<DetectedPlane> const & frame1Planes, std::vector<DetectedPlane> const & frame2Planes,
    nrt::Optional<int&> rnk);

namespace pathak
{
  // rotation covariance is Euler angle
  Eigen::Matrix3f findRotation(nrt::Correspondences const & correspondences,
      std::vector<DetectedPlane> const & frame1Planes, std::vector<DetectedPlane> const & frame2Planes,
      nrt::Optional<Eigen::Matrix3d&> covariance = nrt::OptionalEmpty,
      nrt::Optional<double&> uncertaintyVolume = nrt::OptionalEmpty);

  Eigen::Translation3f findTranslation(nrt::Correspondences const & correspondences,
      std::vector<DetectedPlane> const & frame1Planes, std::vector<DetectedPlane> const & frame2Planes,
      nrt::Optional<Eigen::Matrix3d const &> rotationEstimate = nrt::OptionalEmpty,
      nrt::Optional<int&> rnk = nrt::OptionalEmpty,
      nrt::Optional<Eigen::Matrix3d&> covariance = nrt::OptionalEmpty,
      nrt::Optional<double&> translationUncertainty = nrt::OptionalEmpty);

    Eigen::Vector3d findTranslationByOverlap(nrt::Correspondences const & correspondences,
        std::vector<DetectedPlane> const & frame1Planes, std::vector<DetectedPlane> const & frame2Planes,
        Eigen::Matrix3d const & rotationEstimate,
        nrt::Optional<Eigen::Matrix3d&> covariance = nrt::OptionalEmpty);
}
