#pragma once
#include <Eigen/Core>
// ######################################################################
template<class _Matrix_Type_>
_Matrix_Type_ pseudoInverse(_Matrix_Type_ const & a, double epsilon = std::numeric_limits<typename _Matrix_Type_::Scalar>::epsilon())
{
  typedef Eigen::Matrix<double, _Matrix_Type_::RowsAtCompileTime, _Matrix_Type_::ColsAtCompileTime> DoubleMat;
  
  if(a.rows() > a.cols()) return pseudoInverse(a.transpose().eval()).transpose();

  DoubleMat A = a.template cast<double>();

  Eigen::JacobiSVD<DoubleMat> svd;
  if(_Matrix_Type_::ColsAtCompileTime == Eigen::Dynamic)
    svd.compute(A, Eigen::ComputeThinU | Eigen::ComputeThinV); 
  else
    svd.compute(A, Eigen::ComputeFullU | Eigen::ComputeFullV); 
  
  auto S = svd.singularValues();

  double const tolerance = epsilon * std::max(A.cols(), A.rows()) * std::abs(S[0]);
  
  DoubleMat s = DoubleMat::Zero(S.size(), S.size());
  for(int i=0; i<S.size(); ++i)
  {
    if(S[i] > tolerance)
      s(i,i) = 1.0 / S[i];
  }
  
  auto const V = svd.matrixV();
  auto const U = svd.matrixU();
  auto const Ut = U.adjoint().eval();

  DoubleMat result = V * s * Ut;

  return result.template cast<typename _Matrix_Type_::Scalar>();
}

