#include "RangeImage.H"
#include "VelodyneHelpers.H"

template<size_t numRows>
nrt::Image<nrt::PixGray<float>> velodynerange::rangeImage(nrt::PointCloud2 const & cloud)
{
  nrt::Image<nrt::PixGray<float>> image(cloud.size()/numRows, numRows);

  float last_val = 0;

  auto image_ptr = image.begin();
  for(int r=0; r<image.height(); ++r)
  {
    for(int c=0; c<image.width(); ++c)
    {
      size_t const index = velodynehelpers::index<numRows>(r,c);
      auto const & p = cloud[index].getVector3Map();
      auto m = p.norm();

      if(m > 0)
      {
        image_ptr->set(m);
        last_val = m;
      }
      else
      {
        image_ptr->set(last_val);
      }

      //std::cout << r << "," << c << ": " << index << " " << m << " (" << image.dims() << " " << cloud.size() << ") : " << ((double)cloud.size()/numRows) << " " << std::endl;

      ++image_ptr;
    }
  }

  //float last_val = 0;
  //auto cloud_ptr = cloud.begin();
  //for(size_t idx=0; idx<cloud.size(); ++idx)
  //{
  //  int const seq = idx % 32;
  //  int const row = (seq % 2) ? 16+seq/2 : seq/2;
  //  int const col = (idx - seq)/32;

  //  auto & p = cloud_ptr->geometry();

  //  auto m = cloud_ptr->geometry().magnitude();
  //  if(p.isValid() && m > 1)
  //  {
  //    image(col, row) = m;
  //    last_val = m;
  //  }
  //  else
  //  {
  //    image(col, row) = last_val;
  //  }

  //  ++cloud_ptr;
  //}
  return image;
}


template
nrt::Image<nrt::PixGray<float>> velodynerange::rangeImage<32>(nrt::PointCloud2 const & cloud);
template
nrt::Image<nrt::PixGray<float>> velodynerange::rangeImage<64>(nrt::PointCloud2 const & cloud);
