#include "VelodynePlanarity.H"
#include "VelodyneHelpers.H"
#include <nrt/PointCloud2/Features/Normals.H>
#include <opencv2/opencv.hpp>

template <size_t numRows>
void computeVelodynePlanarity(nrt::PointCloud2 & cloud, int const d_phi, int const d_theta)
{
  if(!cloud.hasField<nrt::PointNormal>())
    throw std::runtime_error(std::string("In ") + __FUNCTION__ + ", cloud must have point normals");

  int const nrows = numRows;
  int const ncols = cloud.size() / nrows;

  for(int c = d_theta; c < ncols - d_theta - 1; ++c)
    for(int r = d_phi; r < nrows - d_phi - 1; ++r)
    {
      auto & centerNormal = cloud.get<nrt::PointNormal>(velodynehelpers::index<numRows>(r,c)).template get<nrt::PointNormal>();
      auto const & centerNormalV = centerNormal.getVector3Map();

      //auto const & centerPoint = cloud[velodyne32::index(r,c)].getVector3Map();

      //double curvature = 0;

      Eigen::Vector3f variance = Eigen::Vector3f::Zero();

      int ncalc = 0;
      for(int cc = c - d_theta; cc <= c + d_theta; ++cc)
        for(int rr = r - d_phi; rr <= r + d_phi; ++rr)
        {
          if(rr == r && cc == c) continue;
          ++ncalc;

          //Eigen::Vector3f const p = cloud[velodyne32::index(rr,cc)].getVector3Map();

          //Eigen::Vector3f const delta = (p - centerPoint).normalized();

          //curvature += std::abs(centerNormalV.dot(delta));
          //curvature += std::pow(std::abs(centerNormalV.dot(delta)), 0.8);
          //curvature += std::pow(centerNormalV.dot(delta), 2);

          Eigen::Vector3f const n = cloud.get<nrt::PointNormal>(velodynehelpers::index<numRows>(rr,cc)).template get<nrt::PointNormal>().getVector3Map();
          auto diff = (centerNormalV - n);
          variance += diff.cwiseAbs();
          //variance += diff.cwiseProduct(diff);
        }

      float const normalizer = ncalc; //(d_phi*2+1) * (d_theta*2+1) - 1;

      variance /= normalizer;
      float const curvature = (variance.x() + variance.y() + variance.z()) / 3.0;

      //curvature /= normalizer;


      centerNormal[3] = 1.0 - curvature;
    }
}

template
void computeVelodynePlanarity<32>(nrt::PointCloud2 & cloud, int const d_phi, int const d_theta);
template
void computeVelodynePlanarity<64>(nrt::PointCloud2 & cloud, int const d_phi, int const d_theta);
