#include "GroundPlaneDetector.H"
#include <nrt/PointCloud2/SampleConcensus/Models/ModelPlane.H>
#include <nrt/PointCloud2/SampleConcensus/RandomSampleConcensus.H>

//GroundPlaneDetector::GroundPlaneDetector(std::string const & instanceName) :
//  nrt::Component(instanceName)
//  itsRANSACIterationsParam(ParamDefRANSACIterations, this),
//  itsRANSACProbabilityParam(ParamDefRANSACProbability, this),
//  itsInlierThresholdParam(ParamDefInlierThreshold, this)
//{ }

std::tuple<Eigen::Hyperplane<float, 3>, nrt::Indices> detectGroundPlane(nrt::PointCloud2 const & cloud,
    size_t const RANSACIterations, float const RANSACProbabilityThreshold, float const inlierThreshold, nrt::Optional<Eigen::Hyperplane<float, 3>> guess)
{

  nrt::Optional<nrt::ModelBase::SampleValidFunction> validationFunc = nrt::OptionalEmpty;

  nrt::ModelBase::SharedPtr model = std::make_shared<nrt::ModelPlane>(
      cloud, validationFunc, inlierThreshold, nrt::OptionalEmpty, 1000, true );             

  Eigen::Hyperplane<float, 3> plane;
  nrt::Indices inliers;
  
  nrt::RandomSampleConcensus RANSAC(.99, 100);
  if(RANSAC.evaluate(model))
  {
    inliers = RANSAC.getInliers();
    nrt::PointCloud2::VectorX planeParameters = model->computeModelCoefficients(inliers);
    planeParameters = model->optimizeModelCoefficients(inliers, planeParameters);
    plane.normal() = planeParameters.block<3,1>(0,0);
    plane.offset() = planeParameters(3);
  }
  
  return std::make_tuple(plane, inliers);
}
