#ifndef POINTCLOUD_REGISTRATION_TRANSFORMATION_TRANSFORMATIONESTIMATIONGICP_H_
#define POINTCLOUD_REGISTRATION_TRANSFORMATION_TRANSFORMATIONESTIMATIONGICP_H_

#include <nrt/Eigen/Eigen.H>
#include <nrt/Eigen/lmdif.H>
#include <nrt/PointCloud2/PointCloud2.H>
#include "bfgs.h"

class BFGSFunctor : public BFGSDummyFunctor<double, 6>
{
  public:
    typedef Eigen::Vector3d Vector3;
    typedef Eigen::Vector4d Vector4;
    typedef Eigen::Matrix3d Matrix3;
    typedef Eigen::Matrix4d Matrix4;
    typedef Eigen::Matrix<double, 6, 1> Vector6;
    typedef Eigen::Transform<double, 3, Eigen::Affine> AffineTransformd;
    typedef Eigen::Transform<float, 3, Eigen::Affine> AffineTransformf;

    //! Constructor
    /*! @param sourceIter Iterator to source cloud
        @param targetIter Iterator to target cloud
        @param distMethod The distance method to use
        @param inputs
        @param values
        @param covariance The covariance matrix used for Mahalanobis distance
                 (only required if using Mahalanobis distance) */
    BFGSFunctor( nrt::PointCloud2::ConstIterator<> && sourceIter,
                 nrt::PointCloud2::ConstIterator<> && targetIter,
                 std::vector<Matrix3> const & mahalanobis,
                 AffineTransformf const & guess,
                 size_t numInputs );

    //! Updates a transformation matrix using the 6D optimization value
    static void updateTransform( Eigen::Matrix4f & t, Vector6 const & x );

    //! Computes the derivative of a rotation R
    void computeRDerivative( Vector6 const & x, Matrix3 const & R, Vector6 & g ) const;

    //! Evaluate error function
    double operator()( Vector6 const & x ) override;

    //! Compute first derivative
    void df( Vector6 const & x, Vector6 & g ) override;

    // Compute second derivative
    void fdf( Vector6 const & x, double & f, Vector6 & g ) override;

  private:
    nrt::PointCloud2::ConstIterator<> & itsSourceBegin;
    nrt::PointCloud2::ConstIterator<> & itsTargetBegin;
    std::vector<Matrix3> const & itsMahalanobis;
    AffineTransformf itsGuess;
    size_t itsNumInputs;
};

#endif // POINTCLOUD_REGISTRATION_TRANSFORMATION_TRANSFORMATIONESTIMATIONGICP_H_
